function [acc_best,svmparam] = give_me_best_acc_svm(kernel_train,kernel_test,y_train,y_test)
c = [0.01,0.1,1,10,100];
parameters = {'-t 4 -c 0.01 -q','-t 4 -c 0.1 -q','-t 4 -c 1 -q','-t 4 -c 10 -q','-t 4 -c 100 -q'};
kfold = length(kernel_train);
acc_best = 0;
acc_best_train = 0;
for i = 1:length(c)
    acc_current_total = 0;
    acc_current = 0;
    for k = 1:kfold
        model = svmtrain(y_train{k}, [(1:size(kernel_train{k},1))',kernel_train{k}], parameters{i});
        [~, acc_temp_train, ~] = svmpredict(y_train{k}, [(1:size(kernel_train{k},1))',kernel_train{k}], model);
        [~, acc_temp_test, ~] = svmpredict(y_test{k}, [(1:size(kernel_test{k},1))',kernel_test{k}], model);
        acc_current_train =  acc_current_total + acc_temp_train(1)/kfold;
        acc_current = acc_current + acc_temp_test(1)/kfold;
    end
    if (acc_current_train > acc_best_train + 0.1) && (acc_current >  acc_best)
       svmparam = parameters{i};
       acc_best = acc_current;
       acc_best_train = acc_current_train;
    end
end
end

